

//vec4 lineBlur(vec2 boxBlurFactor, sampler2D CC_Texture0, vec2 v_texCoord)
//{
//	vec4 sum = vec4(0.0);
//    
//    sum += texture2D(CC_Texture0, v_texCoord - 6.0 * vec2(boxBlurFactor.x, boxBlurFactor.y)) * 0.02;
//    sum += texture2D(CC_Texture0, v_texCoord - 5.0 * vec2(boxBlurFactor.x, boxBlurFactor.y)) * 0.04;
//    sum += texture2D(CC_Texture0, v_texCoord - 4.0 * vec2(boxBlurFactor.x, boxBlurFactor.y)) * 0.06;
//    sum += texture2D(CC_Texture0, v_texCoord - 3.0 * vec2(boxBlurFactor.x, boxBlurFactor.y)) * 0.08;
//    sum += texture2D(CC_Texture0, v_texCoord - 2.0 * vec2(boxBlurFactor.x, boxBlurFactor.y)) * 0.10;
//    sum += texture2D(CC_Texture0, v_texCoord - 1.0 * vec2(boxBlurFactor.x, boxBlurFactor.y)) * 0.12;
//    sum += texture2D(CC_Texture0, v_texCoord                         ) *       0.14;
//    sum += texture2D(CC_Texture0, v_texCoord + 1.0 * vec2(boxBlurFactor.x, boxBlurFactor.y)) * 0.12;
//    sum += texture2D(CC_Texture0, v_texCoord + 2.0 * vec2(boxBlurFactor.x, boxBlurFactor.y)) * 0.10;
//    sum += texture2D(CC_Texture0, v_texCoord + 3.0 * vec2(boxBlurFactor.x, boxBlurFactor.y)) * 0.08;
//    sum += texture2D(CC_Texture0, v_texCoord + 4.0 * vec2(boxBlurFactor.x, boxBlurFactor.y)) * 0.06;
//    sum += texture2D(CC_Texture0, v_texCoord + 5.0 * vec2(boxBlurFactor.x, boxBlurFactor.y)) * 0.04;
//    sum += texture2D(CC_Texture0, v_texCoord + 6.0 * vec2(boxBlurFactor.x, boxBlurFactor.y)) * 0.02;
//    
//    return sum;
//}



/*
 ** SetSaturation   0 = grayscale
 */

vec3 SetSaturation3(vec3 color, float s)
{
    float desaturation = 1.0 - s;
	vec3 grayXfer = vec3(0.3, 0.59, 0.11);
	vec3 gray = vec3(dot(grayXfer, color));
	return mix(color, gray, desaturation);
}

vec4 SetSaturation(vec4 color, float s)
{
    float desaturation = 1.0 - s;
    vec4 grayXfer = vec4(0.3, 0.59, 0.11, 0.0);
    vec4 gray = vec4(dot(grayXfer, color));
    return mix(color, gray, desaturation);
}

/*
 ** Hue, saturation, luminance
 */

vec3 RGBToHSL(vec3 color)
{
	vec3 hsl; // init to 0 to avoid warnings ? (and reverse if + remove first part)
	
	float fmin = min(min(color.r, color.g), color.b);    //Min. value of RGB
	float fmax = max(max(color.r, color.g), color.b);    //Max. value of RGB
	float delta = fmax - fmin;             //Delta RGB value
    
	hsl.z = (fmax + fmin) / 2.0; // Luminance
    
	if (delta == 0.0)		//This is a gray, no chroma...
	{
		hsl.x = 0.0;	// Hue
		hsl.y = 0.0;	// Saturation
	}
	else                                    //Chromatic data...
	{
		if (hsl.z < 0.5)
			hsl.y = delta / (fmax + fmin); // Saturation
		else
			hsl.y = delta / (2.0 - fmax - fmin); // Saturation
		
		float deltaR = (((fmax - color.r) / 6.0) + (delta / 2.0)) / delta;
		float deltaG = (((fmax - color.g) / 6.0) + (delta / 2.0)) / delta;
		float deltaB = (((fmax - color.b) / 6.0) + (delta / 2.0)) / delta;
        
		if (color.r == fmax )
			hsl.x = deltaB - deltaG; // Hue
		else if (color.g == fmax)
			hsl.x = (1.0 / 3.0) + deltaR - deltaB; // Hue
		else if (color.b == fmax)
			hsl.x = (2.0 / 3.0) + deltaG - deltaR; // Hue
        
		if (hsl.x < 0.0)
			hsl.x += 1.0; // Hue
		else if (hsl.x > 1.0)
			hsl.x -= 1.0; // Hue
	}
    
	return hsl;
}

float HueToRGB(float f1, float f2, float hue)
{
	if (hue < 0.0)
		hue += 1.0;
	else if (hue > 1.0)
		hue -= 1.0;
	float res;
	if ((6.0 * hue) < 1.0)
		res = f1 + (f2 - f1) * 6.0 * hue;
	else if ((2.0 * hue) < 1.0)
		res = f2;
	else if ((3.0 * hue) < 2.0)
		res = f1 + (f2 - f1) * ((2.0 / 3.0) - hue) * 6.0;
	else
		res = f1;
	return res;
}

vec3 HSLToRGB(vec3 hsl)
{
	vec3 rgb;
	
	if (hsl.y == 0.0)
		rgb = vec3(hsl.z); // Luminance
	else
	{
		float f2;
		
		if (hsl.z < 0.5)
			f2 = hsl.z * (1.0 + hsl.y);
		else
			f2 = (hsl.z + hsl.y) - (hsl.y * hsl.z);
        
		float f1 = 2.0 * hsl.z - f2;
		
		rgb.r = HueToRGB(f1, f2, hsl.x + (1.0/3.0));
		rgb.g = HueToRGB(f1, f2, hsl.x);
		rgb.b= HueToRGB(f1, f2, hsl.x - (1.0/3.0));
	}
	
	return rgb;
}


/*
 ** Contrast, saturation, brightness
 */

// For all settings: 1.0 = 100% 0.5=50% 1.5 = 150%
vec3 ContrastSaturationBrightness(vec3 color, float brt, float sat, float con)
{
	// Increase or decrease theese values to adjust r, g and b color channels seperately
	const float AvgLumR = 0.5;
	const float AvgLumG = 0.5;
	const float AvgLumB = 0.5;
	
	const vec3 LumCoeff = vec3(0.2125, 0.7154, 0.0721);
	
	vec3 AvgLumin = vec3(AvgLumR, AvgLumG, AvgLumB);
	vec3 brtColor = color * brt;
	vec3 intensity = vec3(dot(brtColor, LumCoeff));
	vec3 satColor = mix(intensity, brtColor, sat);
	vec3 conColor = mix(AvgLumin, satColor, con);
	return conColor;
}


/*
 ** Float blending modes
 */

#define BlendLinearDodgef 			BlendAddf
#define BlendLinearBurnf 			BlendSubstractf
#define BlendAddf(base, blend) 		min(base + blend, 1.0)
#define BlendSubstractf(base, blend) 	max(base + blend - 1.0, 0.0)
#define BlendLightenf(base, blend) 		max(blend, base)
#define BlendDarkenf(base, blend) 		min(blend, base)
#define BlendLinearLightf(base, blend) 	(blend < 0.5 ? BlendLinearBurnf(base, (2.0 * blend)) : BlendLinearDodgef(base, (2.0 * (blend - 0.5))))
#define BlendScreenf(base, blend) 		(1.0 - ((1.0 - base) * (1.0 - blend)))
#define BlendOverlayf(base, blend) 	(base < 0.5 ? (2.0 * base * blend) : (1.0 - 2.0 * (1.0 - base) * (1.0 - blend)))
#define BlendSoftLightf(base, blend) 	((blend < 0.5) ? (2.0 * base * blend + base * base * (1.0 - 2.0 * blend)) : (sqrt(base) * (2.0 * blend - 1.0) + 2.0 * base * (1.0 - blend)))
#define BlendColorDodgef(base, blend) 	((blend == 1.0) ? blend : min(base / (1.0 - blend), 1.0))
#define BlendColorBurnf(base, blend) 	((blend == 0.0) ? blend : max((1.0 - ((1.0 - base) / blend)), 0.0))
#define BlendVividLightf(base, blend) 	((blend < 0.5) ? BlendColorBurnf(base, (2.0 * blend)) : BlendColorDodgef(base, (2.0 * (blend - 0.5))))
#define BlendPinLightf(base, blend) 	((blend < 0.5) ? BlendDarkenf(base, (2.0 * blend)) : BlendLightenf(base, (2.0 *(blend - 0.5))))
#define BlendHardMixf(base, blend) 	((BlendVividLightf(base, blend) < 0.5) ? 0.0 : 1.0)
#define BlendReflectf(base, blend) 		((blend == 1.0) ? blend : min(base * base / (1.0 - blend), 1.0))


/*
 ** Vector3 blending modes
 */

// Component wise blending
#define Blend(base, blend, funcf) 		vec3(funcf(base.r, blend.r), funcf(base.g, blend.g), funcf(base.b, blend.b))

#define BlendNormal(base, blend) 		(blend)
#define BlendLighten				BlendLightenf
#define BlendDarken				BlendDarkenf
#define BlendMultiply(base, blend) 		(base * blend)
#define BlendAverage(base, blend) 		((base + blend) / 2.0)
#define BlendAdd(base, blend) 		min(base + blend, vec3(1.0))
#define BlendSubstract(base, blend) 	max(base + blend - vec3(1.0), vec3(0.0))
#define BlendDifference(base, blend) 	abs(base - blend)
#define BlendNegation(base, blend) 	(vec3(1.0) - abs(vec3(1.0) - base - blend))
#define BlendExclusion(base, blend) 	(base + blend - 2.0 * base * blend)
#define BlendScreen(base, blend) 		Blend(base, blend, BlendScreenf)
#define BlendOverlay(base, blend) 		Blend(base, blend, BlendOverlayf)
#define BlendSoftLight(base, blend) 	Blend(base, blend, BlendSoftLightf)
#define BlendHardLight(base, blend) 	BlendOverlay(blend, base)
#define BlendColorDodge(base, blend) 	Blend(base, blend, BlendColorDodgef)
#define BlendColorBurn(base, blend) 	Blend(base, blend, BlendColorBurnf)
#define BlendLinearDodge			BlendAdd
#define BlendLinearBurn			BlendSubstract
// Linear Light is another contrast-increasing mode
// If the blend color is darker than midgray, Linear Light darkens the image by decreasing the brightness. If the blend color is lighter than midgray, the result is a brighter image due to increased brightness.
#define BlendLinearLight(base, blend) 	Blend(base, blend, BlendLinearLightf)
#define BlendVividLight(base, blend) 	Blend(base, blend, BlendVividLightf)
#define BlendPinLight(base, blend) 		Blend(base, blend, BlendPinLightf)
#define BlendHardMix(base, blend) 		Blend(base, blend, BlendHardMixf)
#define BlendReflect(base, blend) 		Blend(base, blend, BlendReflectf)
#define BlendGlow(base, blend) 		BlendReflect(blend, base)
#define BlendPhoenix(base, blend) 		(min(base, blend) - max(base, blend) + vec3(1.0))
#define BlendOpacity(base, blend, F, O) 	(F(base, blend) * O + blend * (1.0 - O))


// Hue Blend mode creates the result color by combining the luminance and saturation of the base color with the hue of the blend color.
vec3 BlendHue(vec3 base, vec3 blend)
{
	vec3 baseHSL = RGBToHSL(base);
	return HSLToRGB(vec3(RGBToHSL(blend).r, baseHSL.g, baseHSL.b));
}

// Saturation Blend mode creates the result color by combining the luminance and hue of the base color with the saturation of the blend color.
vec3 BlendSaturation(vec3 base, vec3 blend)
{
	vec3 baseHSL = RGBToHSL(base);
	return HSLToRGB(vec3(baseHSL.r, RGBToHSL(blend).g, baseHSL.b));
}

// Color Mode keeps the brightness of the base color and applies both the hue and saturation of the blend color.
vec3 BlendColor(vec3 base, vec3 blend)
{
	vec3 blendHSL = RGBToHSL(blend);
	return HSLToRGB(vec3(blendHSL.r, blendHSL.g, RGBToHSL(base).b));
}

// Luminosity Blend mode creates the result color by combining the hue and saturation of the base color with the luminance of the blend color.
vec3 BlendLuminosity(vec3 base, vec3 blend)
{
	vec3 baseHSL = RGBToHSL(base);
	return HSLToRGB(vec3(baseHSL.r, baseHSL.g, RGBToHSL(blend).b));
}


/*
 ** Gamma correction
 */

#define GammaCorrection(color, gamma)								pow(color, 1.0 / gamma)

/*
 ** Levels control (input (+gamma), output)
 */

#define LevelsControlInputRange(color, minInput, maxInput)                      min(max(color - vec3(minInput), vec3(0.0)) / (vec3(maxInput) - vec3(minInput)), vec3(1.0))
#define LevelsControlInput(color, minInput, gamma, maxInput)                    GammaCorrection(LevelsControlInputRange(color, minInput, maxInput), gamma)
#define LevelsControlOutputRange(color, minOutput, maxOutput)                   mix(vec3(minOutput), vec3(maxOutput), color)
#define LevelsControl(color, minInput, gamma, maxInput, minOutput, maxOutput)   LevelsControlOutputRange(LevelsControlInput(color, minInput, gamma, maxInput), minOutput, maxOutput)


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////



#ifdef GL_ES
precision highp float;
#endif

varying vec4 v_fragmentColor;
varying vec2 v_texCoord;
uniform sampler2D CC_Texture0;
const vec3 bw = vec3(0.2125, 0.7154, 0.0721);

// mask
uniform sampler2D u_maskTexture;

// custom parameters
uniform vec2 contentSize;
uniform float customGamma;
uniform float customSaturation;
uniform float customExposure;
uniform vec3  customTintOverlay;
uniform vec2 customBlurSize;  // horizontal blur (divide by texture width)
uniform float customRGBSplit;
uniform float customHasAlpha;
uniform float customFog;

// fog algorithm
float ff = 0.25;  // scale range to 0 to 0.25
//customGamma = customGamma + customFog;
//customBlurSize = vec2(customBlurSize.x + 2.0*customFog, customBlurSize.y + 2.0*customFog);

vec2 blurFactor = vec2(customBlurSize.x*(1.0 / contentSize.x), customBlurSize.y*(1.0 / contentSize.y) );
//float glowIntensity = (customBlurSize.x/10.0);
float RGBSplit = customRGBSplit/contentSize.x;



// custom glow
//float customGlowIntensity = 1.0;  // 0 to 1
//vec2 customGlow = vec2(10.0, 10.0);       //  0 to 10
//vec4 customGlowColor = vec4(1.0, 0.3, 0.0, 1.0);

//uniform float customGlowIntensity ;
//uniform vec2 customGlow;
//uniform vec4 customGlowColor;
//vec4 sumX, sumY;
//vec2 glowFactor = vec2( customGlow.x / contentSize.x, customGlow.y / contentSize.y );

float normpdf(in float x, in float sigma)
{
    return 0.39894*exp(-0.5*x*x/(sigma*sigma))/sigma;
}

vec4 colR, colG, colB;
vec4 sum, col;

void main()
{
   
    //float luminance = dot(texture2D(CC_Texture0, v_texCoord).rgb, bw);
    //luminance = gammaCorrection(luminance, gamma);
    //luminance = max*luminance;
    //gl_FragColor = v_fragmentColor * vec4(vec3(luminance), 1.0);

    //ASC CDL (American Society of Cinematographers Color Decision List)
    // out = ((input*slope)+offset)^(1/gamma)
    
    // lift, gamma, gain
    // outputColor = (gainColor*(inputColor+liftColor*(1-inputColor)))^(1/gammaColor)
   
    //xhttp://www.francois-tarlier.com/blog/exposureoffsetgamma-photoshop-tool-to-shaders/
    // exposure offset gamma
    //output = ((input*exposure) + offset)^(1/gamma)

    col = v_fragmentColor * texture2D(CC_Texture0, v_texCoord);
    
   // single pass gaussian blur (looks like box blur?)
    //hxttps://www.shadertoy.com/view/XdfGDH
//    if (customBlurSize.x > 0.0) {
//        vec2 fragCoord = v_texCoord * contentSize;
//        const int mSize = 9;
//        const int kSize = (mSize-1)/2;
//        float kernel[mSize];
//        vec3 final_colour = vec3(0.0);
//
//        //create the 1-D kernel
//        float sigma = 2.0 ; //7.0;
//        float Z = 0.0;
//        for (int j = 0; j <= kSize; ++j)
//        {
//            kernel[kSize+j] = kernel[kSize-j] = normpdf(float(j), sigma);
//        }
//
//        //get the normalization factor (as the gaussian has been clamped)
//        for (int j = 0; j < mSize; ++j)
//        {
//            Z += kernel[j];
//        }
//
//        //read out the texels
//        for (int i=-kSize; i <= kSize; ++i)
//        {
//            for (int j=-kSize; j <= kSize; ++j)
//            {
//                final_colour += (kernel[kSize+j]*kernel[kSize+i]*texture2D(CC_Texture0, (fragCoord.xy+ customBlurSize * vec2(float(i),float(j))) / contentSize.xy).rgb);
//            }
//        }
//
//        vec3 blurTex = vec3(final_colour/(Z*Z)) * v_fragmentColor.rgb;
//
//        // bloom mix  0.75
//        //float bloomMix =  1.0;
//        //col = vec4(mix(col.rgb, blurTex, bloomMix), 1.0);
//        col = vec4(blurTex, 1.0);
//    }


  //SINGLE PASS BOX BLUR
//    if (customBlurSize.x > 0.0) {
//        vec2 fragCoord2 = v_texCoord * contentSize;
//        //vec4 tex1Color = texture2D(CC_Texture0, fragCoord.xy / contentSize.xy);
//        vec4 tex1Color = texture2D(CC_Texture0, v_texCoord);
//
//
//        int kSize = 3;  //  3 - 5
//        vec3 avg = vec3(0.0);
//        for (int i=-kSize; i <= kSize; ++i) {
//            for (int j = -kSize; j <= kSize; ++j) {
//                avg = avg + texture2D(CC_Texture0, (fragCoord2.xy + customBlurSize*vec2(float(i), float(j)))/contentSize.xy).xyz;
//            }
//        }
//
//        int area = (2*kSize + 1) * (2*kSize + 1);  // number of calculations; x=3; area=49
//        avg = avg.xyz/vec3(area)  * v_fragmentColor.rgb;
//
//        //col = vec4(avg, 1.0);
//
//        // bloom mix  0.75
//        //float boxBloomMix = 0.7;
//        //col = vec4(mix(col.rgb, avg, boxBloomMix), 1.0);
//        col = vec4(avg, 1.0);
//    }

    
    //////////////////////////////////////////////////////////////////////////////
    // blur - horizontal blur
//    if (customBlurSize.x > 0.0) {
//
//        // single pass box blur
//        vec2 fragCoord2 = v_texCoord * contentSize;
//        //vec4 tex1Color = texture2D(CC_Texture0, fragCoord.xy / contentSize.xy);
//        vec4 tex1Color = texture2D(CC_Texture0, v_texCoord);
//
//
//        int kSize = 5; // 3;  //  4  // 5
//        vec3 avg = vec3(0.0);
//        for (int i=-kSize; i <= kSize; ++i) {
//            for (int j = -kSize; j <= kSize; ++j) {
//                avg = avg + texture2D(CC_Texture0, (fragCoord2.xy + customBlurSize*vec2(float(i), float(j)))/contentSize.xy).xyz;
//            }
//        }
//
//        int area = (2*kSize + 1) * (2*kSize + 1);  // number of calculations; x=3; area=49
//        avg = avg.xyz/vec3(area);
//
//        col = vec4(avg, col.a) * v_fragmentColor;
//        
//        // bloom mix  0.75
//        //float boxBloomMix = 0.7;
//        //col = vec4(mix(col.rgb, avg, boxBloomMix), 1.0);
//
//    }
//    else
    if (customBlurSize.x > 0.0 ) {
        sum = vec4(0.0);
        // less copies than image blur, faster
        sum += texture2D(CC_Texture0, v_texCoord - 4.0 * vec2(blurFactor.x, 0)) * 0.05;
        sum += texture2D(CC_Texture0, v_texCoord - 3.0 * vec2(blurFactor.x, 0)) * 0.09;
        sum += texture2D(CC_Texture0, v_texCoord - 2.0 * vec2(blurFactor.x, 0)) * 0.12;
        sum += texture2D(CC_Texture0, v_texCoord - 1.0 * vec2(blurFactor.x, 0)) * 0.15;
        sum += texture2D(CC_Texture0, v_texCoord                              ) * 0.16;
        sum += texture2D(CC_Texture0, v_texCoord + 1.0 * vec2(blurFactor.x, 0)) * 0.15;
        sum += texture2D(CC_Texture0, v_texCoord + 2.0 * vec2(blurFactor.x, 0)) * 0.12;
        sum += texture2D(CC_Texture0, v_texCoord + 3.0 * vec2(blurFactor.x, 0)) * 0.09;
        sum += texture2D(CC_Texture0, v_texCoord + 4.0 * vec2(blurFactor.x, 0)) * 0.05;
        col = sum * v_fragmentColor;

        
//        sum += texture2D(CC_Texture0, v_texCoord - 6.0 * vec2(blurFactor.x, 0)) * 0.02;
//        sum += texture2D(CC_Texture0, v_texCoord - 5.0 * vec2(blurFactor.x, 0)) * 0.04;
//        sum += texture2D(CC_Texture0, v_texCoord - 4.0 * vec2(blurFactor.x, 0)) * 0.06;
//        sum += texture2D(CC_Texture0, v_texCoord - 3.0 * vec2(blurFactor.x, 0)) * 0.08;
//        sum += texture2D(CC_Texture0, v_texCoord - 2.0 * vec2(blurFactor.x, 0)) * 0.10;
//        sum += texture2D(CC_Texture0, v_texCoord - 1.0 * vec2(blurFactor.x, 0)) * 0.12;
//        sum += texture2D(CC_Texture0, v_texCoord                         ) *       0.14;
//        sum += texture2D(CC_Texture0, v_texCoord + 1.0 * vec2(blurFactor.x, 0)) * 0.12;
//        sum += texture2D(CC_Texture0, v_texCoord + 2.0 * vec2(blurFactor.x, 0)) * 0.10;
//        sum += texture2D(CC_Texture0, v_texCoord + 3.0 * vec2(blurFactor.x, 0)) * 0.08;
//        sum += texture2D(CC_Texture0, v_texCoord + 4.0 * vec2(blurFactor.x, 0)) * 0.06;
//        sum += texture2D(CC_Texture0, v_texCoord + 5.0 * vec2(blurFactor.x, 0)) * 0.04;
//        sum += texture2D(CC_Texture0, v_texCoord + 6.0 * vec2(blurFactor.x, 0)) * 0.02;
//        col = sum * v_fragmentColor * 0.5;
//
//        sum = vec4(0.0);
//        sum += texture2D(CC_Texture0, v_texCoord - 6.0 * vec2(0, blurFactor.y)) * 0.02;
//        sum += texture2D(CC_Texture0, v_texCoord - 5.0 * vec2(0, blurFactor.y)) * 0.04;
//        sum += texture2D(CC_Texture0, v_texCoord - 4.0 * vec2(0, blurFactor.y)) * 0.06;
//        sum += texture2D(CC_Texture0, v_texCoord - 3.0 * vec2(0, blurFactor.y)) * 0.08;
//        sum += texture2D(CC_Texture0, v_texCoord - 2.0 * vec2(0, blurFactor.y)) * 0.10;
//        sum += texture2D(CC_Texture0, v_texCoord - 1.0 * vec2(0, blurFactor.y)) * 0.12;
//        sum += texture2D(CC_Texture0, v_texCoord                         ) *       0.14;
//        sum += texture2D(CC_Texture0, v_texCoord + 1.0 * vec2(0, blurFactor.y)) * 0.12;
//        sum += texture2D(CC_Texture0, v_texCoord + 2.0 * vec2(0, blurFactor.y)) * 0.10;
//        sum += texture2D(CC_Texture0, v_texCoord + 3.0 * vec2(0, blurFactor.y)) * 0.08;
//        sum += texture2D(CC_Texture0, v_texCoord + 4.0 * vec2(0, blurFactor.y)) * 0.06;
//        sum += texture2D(CC_Texture0, v_texCoord + 5.0 * vec2(0, blurFactor.y)) * 0.04;
//        sum += texture2D(CC_Texture0, v_texCoord + 6.0 * vec2(0, blurFactor.y)) * 0.02;
//        
//        col += sum * v_fragmentColor * 0.5;

        
        
         //col = sum * v_fragmentColor;

// 
//        sum = vec4(0.0);
//        sum += texture2D(CC_Texture0, v_texCoord - 4.0 * vec2(blurFactor.x, 0)) * 0.05;
//        sum += texture2D(CC_Texture0, v_texCoord - 3.0 * vec2(blurFactor.x, 0)) * 0.09;
//        sum += texture2D(CC_Texture0, v_texCoord - 2.0 * vec2(blurFactor.x, 0)) * 0.12;
//        sum += texture2D(CC_Texture0, v_texCoord - 1.0 * vec2(blurFactor.x, 0)) * 0.15;
//        sum += texture2D(CC_Texture0, v_texCoord                 ) *       0.16;
//        sum += texture2D(CC_Texture0, v_texCoord + 1.0 * vec2(blurFactor.x, 0)) * 0.15;
//        sum += texture2D(CC_Texture0, v_texCoord + 2.0 * vec2(blurFactor.x, 0)) * 0.12;
//        sum += texture2D(CC_Texture0, v_texCoord + 3.0 * vec2(blurFactor.x, 0)) * 0.09;
//        sum += texture2D(CC_Texture0, v_texCoord + 4.0 * vec2(blurFactor.x, 0)) * 0.05;
//        col = sum * v_fragmentColor * 0.5;
//        
//        sum = vec4(0.0);
//        sum += texture2D(CC_Texture0, v_texCoord - 4.0 * vec2(0, blurFactor.y)) * 0.05;
//        sum += texture2D(CC_Texture0, v_texCoord - 3.0 * vec2(0, blurFactor.y)) * 0.09;
//        sum += texture2D(CC_Texture0, v_texCoord - 2.0 * vec2(0, blurFactor.y)) * 0.12;
//        sum += texture2D(CC_Texture0, v_texCoord - 1.0 * vec2(0, blurFactor.y)) * 0.15;
//        sum += texture2D(CC_Texture0, v_texCoord                 ) *       0.16;
//        sum += texture2D(CC_Texture0, v_texCoord + 1.0 * vec2(0, blurFactor.y)) * 0.15;
//        sum += texture2D(CC_Texture0, v_texCoord + 2.0 * vec2(0, blurFactor.y)) * 0.12;
//        sum += texture2D(CC_Texture0, v_texCoord + 3.0 * vec2(0, blurFactor.y)) * 0.09;
//        sum += texture2D(CC_Texture0, v_texCoord + 4.0 * vec2(0, blurFactor.y)) * 0.05;
//        
//        col += sum * v_fragmentColor * 0.5;
//        //col = sum * v_fragmentColor;

    }
    //////////////////////////////////////////////////////////////////////////////
    // color rgb shift (i.e. chromatic aberration)
    else if (abs(customRGBSplit) > 2.0) {   // (abs(RGBSplit) > 0.0005) {
        colR = texture2D(CC_Texture0, v_texCoord - vec2(RGBSplit, 0.0));
        colG = texture2D(CC_Texture0, v_texCoord + vec2(RGBSplit, 0.0));
        colB = texture2D(CC_Texture0, v_texCoord) ;

        col = vec4(colR.r, colG.g, colB.b, colB.a) * v_fragmentColor;
    }
    //////////////////////////////////////////////////////////////////////////////
    else {
         col = v_fragmentColor * texture2D(CC_Texture0, v_texCoord);
    }
    //////////////////////////////////////////////////////////////////////////////
    
    
    //////////////////////////////////////////////////////////////////////////////
    //  glow
//    if (customGlow.x > 0.0  ||  customGlow.y > 0.0) {
//        
//        sumX = vec4(0.0);
//        sumY = vec4(0.0);
//        sumX = lineBlur(vec2(glowFactor.x, 0.0), CC_Texture0, v_texCoord);
//        sumY = lineBlur(vec2(0.0, glowFactor.y), CC_Texture0, v_texCoord);
//        col += sumX * v_fragmentColor * customGlowColor * customGlowIntensity;
//        col += sumY * v_fragmentColor * customGlowColor * customGlowIntensity;
//    }
    
    //////////////////////////////////////////////////////////////////////////////
    // gamma, brightness, saturation
    vec4 col2 = col;
//    col2 = vec4(SetSaturation(vec3(col.r, col.g, col.b), customSaturation), col.a);
    
//    if (customHasAlpha > 0.5) {
//        col2 = SetSaturation(vec4(col.r, col.g, col.b, col.a), customSaturation);  // use this for alphaElement
//        //col2 = SetSaturation(vec3(col.r, col.g, col.b), customSaturation);  // use this for alphaElement
//    }
//    else
//    {
//        col2 = SetSaturation(vec4(col.r, col.g, col.b, 1.0), customSaturation);
//    }

    col2 = SetSaturation(vec4(col.r, col.g, col.b, 1.0), customSaturation);
    
    if (customSaturation < 1.0) {
        vec3 colTemp = SetSaturation3(vec3(col.r, col.g, col.b), customSaturation);  // use this for alphaElement vec3 version, preserve alpha
        col2 = vec4(colTemp, 1.0);
    }

    
    //col2.a = col.a;
    col2.r = GammaCorrection(col2.r, customGamma); // * customExposure;
    col2.g = GammaCorrection(col2.g, customGamma); // * customExposure;
    col2.b = GammaCorrection(col2.b, customGamma); // * customExposure;
    
    // overlay function for colorTint
    //col2 = vec4(BlendOverlay(col2, customTintOverlay), 1.0);
    
    // fog: output levels
//    vec4 col3;
//    col3 = vec4(LevelsControlOutputRange(vec3(col2.r, col2.g, col2.b), customFog*col2.a*ff, (1.0 - customFog*ff)*col2.a), col2.a);

    // masking
//    vec4 maskColor = texture2D(u_maskTexture, v_texCoord).rgba;
//    float m = 1.0 - maskColor.r;  // mask is white
//    vec4 resultColor = vec4(col2.r * m, col2.g * m, col2.b * m, col2.a * m);
//    gl_FragColor = resultColor;

    gl_FragColor = col2;
    
    //gl_FragColor = v_fragmentColor * texture2D(CC_Texture0, v_texCoord);  // original
    
}


